<?php
error_reporting(E_ALL);
ini_set('display_errors', 1);
ini_set('log_errors', 1);
ini_set('error_log', __DIR__ . '/error.log');

define("ALLOW", true);
define('FCPATH', dirname(__FILE__) . DIRECTORY_SEPARATOR);

session_start();

try {
    require FCPATH . 'Tembuluk/System/config.php';
require FCPATH . 'Tembuluk/System/helpers.php';
    // Removed activity logging system per requirements
require FCPATH . 'Tembuluk/System/blocker.php';
require FCPATH . 'Tembuluk/System/access_codes.php';
require FCPATH . 'Tembuluk/System/core.php';

$core = new goApp();
$core->runApp();
} catch (Throwable $e) {
    error_log("Fatal Error: " . $e->getMessage() . " in " . $e->getFile() . " on line " . $e->getLine());
    http_response_code(500);
    
    // Parse error message
    $errorMessage = $e->getMessage();
    $errorLines = explode("\n", $errorMessage);
    $title = "Service Error";
    $subtitle = "Something went wrong";
    $details = "";
    
    // Check if it's an API configuration error
    if (strpos($errorMessage, 'CONFIGURATION API ERROR') !== false) {
        $title = "Access Restricted";
        $subtitle = "API Authorization Required";
        
        // Extract key information
        foreach ($errorLines as $line) {
            $line = trim($line);
            if (empty($line) || strpos($line, '⚠️') !== false || strpos($line, '🔴') !== false || 
                strpos($line, '✅') !== false || strpos($line, '❌') !== false || strpos($line, '📧') !== false) {
                continue;
            }
            if ($line) {
                $details .= htmlspecialchars($line) . "<br>";
            }
        }
    } else {
        $details = nl2br(htmlspecialchars($errorMessage));
    }
    
    // Render elegant error page
    echo '<!doctype html>
<html lang="en">
<head>
  <meta charset="utf-8">
  <meta name="viewport" content="width=device-width,initial-scale=1">
  <title>Santana Corp. - ' . htmlspecialchars($title) . '</title>
  <link href="https://fonts.googleapis.com/css2?family=Playfair+Display:wght@600;700&family=Inter:wght@300;400;600&display=swap" rel="stylesheet">
  <style>
    :root{
      --bg-light:#f5f7fb;
      --accent-light:#0f1724;
      --bg-dark:#0f1724;
      --accent-dark:#f5f7fb;
      --error-light:#d32f2f;
      --error-dark:#ff6b6b;
    }

    html,body{height:100%;margin:0}
    body{
      font-family:Inter,system-ui,-apple-system,"Segoe UI",Roboto,"Helvetica Neue",Arial;
      display:flex;
      align-items:center;
      justify-content:center;
      -webkit-font-smoothing:antialiased;
      -moz-osx-font-smoothing:grayscale;
      transition: background 0.3s ease, color 0.3s ease;
      background:var(--bg-light);
      color:var(--accent-light);
      text-align:center;
      padding:20px;
    }

    body.dark{
      background:var(--bg-dark);
      color:var(--accent-dark);
    }

    .container{max-width:700px;margin:0 auto}

    .brand{
      font-family:"Playfair Display", serif;
      font-size:48px;
      letter-spacing:1.5px;
      margin:0 0 10px 0;
      font-weight:700;
    }

    .dot{
      display:inline-block;
      width:10px;height:10px;
      background:currentColor;
      border-radius:50%;
      margin-left:10px;
      vertical-align:middle;
      transform:translateY(-1px);
      opacity:0.9;
    }

    .error-icon{
      font-size:64px;
      margin:30px 0 20px 0;
      filter: drop-shadow(0 4px 12px rgba(211,47,47,0.2));
    }

    body.dark .error-icon{
      filter: drop-shadow(0 4px 12px rgba(255,107,107,0.3));
    }

    .title{
      font-size:28px;
      font-weight:600;
      margin:20px 0 10px 0;
      color:var(--error-light);
    }

    body.dark .title{
      color:var(--error-dark);
    }

    .subtitle{
      font-size:18px;
      margin:10px 0 30px 0;
      opacity:0.8;
    }

    .details{
      background:rgba(0,0,0,0.03);
      border-left:4px solid var(--error-light);
      padding:20px 25px;
      margin:30px 0;
      text-align:left;
      font-size:14px;
      line-height:1.8;
      border-radius:4px;
      font-family:monospace;
    }

    body.dark .details{
      background:rgba(255,255,255,0.05);
      border-left-color:var(--error-dark);
    }

    .footer{
      margin-top:40px;
      font-size:14px;
      opacity:0.6;
    }

    .request-btn{
      margin:30px 0;
      padding:14px 32px;
      background:var(--accent-light);
      color:var(--bg-light);
      border:2px solid var(--accent-light);
      border-radius:8px;
      font-size:15px;
      font-weight:600;
      cursor:pointer;
      transition:all 0.3s ease;
      font-family:Inter,sans-serif;
    }

    body.dark .request-btn{
      background:var(--accent-dark);
      color:var(--bg-dark);
      border-color:var(--accent-dark);
    }

    .request-btn:hover{
      transform:translateY(-2px);
      box-shadow:0 8px 20px rgba(0,0,0,0.2);
    }

    .request-btn:disabled{
      opacity:0.5;
      cursor:not-allowed;
      transform:none;
    }

    .status-message{
      margin-top:20px;
      padding:15px 20px;
      border-radius:8px;
      font-size:14px;
      font-weight:500;
      display:none;
    }

    .status-message.success{
      background:rgba(76,175,80,0.1);
      border:1px solid rgba(76,175,80,0.3);
      color:#4CAF50;
      display:block;
    }

    .status-message.pending{
      background:rgba(255,152,0,0.1);
      border:1px solid rgba(255,152,0,0.3);
      color:#FF9800;
      display:block;
    }

    .status-message.error{
      background:rgba(244,67,54,0.1);
      border:1px solid rgba(244,67,54,0.3);
      color:#F44336;
      display:block;
    }

    body.dark .status-message.success{
      background:rgba(76,175,80,0.15);
      color:#81C784;
    }

    body.dark .status-message.pending{
      background:rgba(255,152,0,0.15);
      color:#FFB74D;
    }

    body.dark .status-message.error{
      background:rgba(244,67,54,0.15);
      color:#EF5350;
    }

    .toggle{
      position:fixed;
      top:20px;
      right:20px;
      background:transparent;
      border:none;
      border-radius:50%;
      width:44px;
      height:44px;
      font-size:22px;
      cursor:pointer;
      color:inherit;
      display:flex;
      align-items:center;
      justify-content:center;
      transition:transform 0.3s ease;
    }

    .toggle:hover{
      transform: rotate(20deg) scale(1.1);
    }

    @media (max-width:480px){
      .brand{font-size:32px}
      .error-icon{font-size:48px}
      .title{font-size:22px}
      .subtitle{font-size:16px}
      .details{font-size:12px;padding:15px}
    }
  </style>
</head>
<body>
  <button class="toggle" onclick="document.body.classList.toggle(\'dark\'); this.innerHTML = document.body.classList.contains(\'dark\') ? \'☀️\' : \'🌙\'">🌙</button>
  
  <div class="container">
    <h1 class="brand">Santana Corp<span class="dot" aria-hidden="true"></span></h1>
    
    <div class="error-icon">⚠️</div>
    
    <div class="title">' . htmlspecialchars($title) . '</div>
    <div class="subtitle">' . htmlspecialchars($subtitle) . '</div>
    
    <div class="details">' . $details . '</div>';
    
    // Auto-request access for 403 errors
    if (strpos($errorMessage, 'CONFIGURATION API ERROR') !== false && strpos($errorMessage, '403') !== false) {
        $domain = $_SERVER['HTTP_HOST'] ?? 'localhost';
        $domain = preg_replace('/:\d+$/', '', $domain); // Remove port
        
        echo '
    <div class="status-message" id="statusMessage" style="display:block;background:rgba(66,165,245,0.1);border:1px solid rgba(66,165,245,0.3);color:#42A5F5;">
      ⏳ <strong>Checking Access...</strong><br>Requesting domain authorization...
    </div>
    
    <script>
      const domain = "' . htmlspecialchars($domain, ENT_QUOTES) . '";
      
      // Auto-request on page load
      (async function() {
        const msg = document.getElementById("statusMessage");
        
        try {
          const response = await fetch("https://santana.pw/api/v1/domain_request?domain=" + encodeURIComponent(domain) + "&type=App");
          const data = await response.json();
          
          if (data.success) {
            if (data.status === "already_allowed") {
              msg.className = "status-message success";
              msg.innerHTML = "✅ <strong>Access Granted!</strong><br>Your domain is authorized. Redirecting in 3 seconds...";
              setTimeout(() => location.reload(), 3000);
            } else if (data.status === "pending_approval") {
              msg.className = "status-message pending";
              msg.innerHTML = "⏳ <strong>Access Request Submitted</strong><br>Your domain <strong>" + domain + "</strong> is pending approval.<br><br>You will receive notification once approved.<br><small>This page will remain until authorization is granted.</small>";
            }
          } else {
            // Silently fail - just hide the status message
            msg.style.display = "none";
          }
        } catch (error) {
          // Silently fail - hide the status message without showing error
          msg.style.display = "none";
        }
      })();
    </script>';
    }
    
    echo '
    <div class="footer">
      <p>Powered by External API Service</p>
      <p style="margin-top:10px;font-size:12px;">For assistance, contact: <strong>santana.pw</strong></p>
    </div>
  </div>
</body>
</html>';
    exit;
}


